#ifndef _SPI_SD_DRIVER_H_
#define _SPI_SD_DRIVER_H_

/* Private define ------------------------------------------------------------*/
/* SDͶ */
#define SD_TYPE_MMC     0
#define SD_TYPE_V1      1
#define SD_TYPE_V2      2
#define SD_TYPE_V2HC    4

/* SPIٶ*/
#define SPI_SPEED_LOW   0
#define SPI_SPEED_HIGH  1

/* SDݽǷͷߺ궨 */
#define NO_RELEASE      1
#define RELEASE         1

/* SDָ */
#define CMD0    0       //λ
#define CMD9    9       //9 CSD
#define CMD10   10      //10CID
#define CMD12   12      //12ֹͣݴ
#define CMD16   16      //16SectorSize Ӧ0x00
#define CMD17   17      //17sector
#define CMD18   18      //18Multi sector
#define ACMD23  23      //23ösectorдǰԤȲNblock
#define CMD24   24      //24дsector
#define CMD25   25      //25дMulti sector
#define ACMD41  41      //41Ӧ0x00
#define CMD55   55      //55Ӧ0x01
#define CMD58   58      //58OCRϢ
#define CMD59   59      //59ʹ/ֹCRCӦ0x00




/* Private macro -------------------------------------------------------------*/
//SDCSƬѡʹܶ˲
#define SD_CS_ENABLE()      GPIO_ResetBits(GPIOB,GPIO_Pin_12)   //ѡSD
#define SD_CS_DISABLE()     GPIO_SetBits(GPIOB,GPIO_Pin_12)     //ѡSD

//#define SD_PWR_ON()         GPIO_ResetBits(GPIOD,GPIO_Pin_10)  //SDϵ
//#define SD_PWR_OFF()        GPIO_SetBits(GPIOD,GPIO_Pin_10)    //SDϵ

#define SD_DET()            !GPIO_ReadInputDataBit(GPIOC,GPIO_Pin_6) //п
                                                                    //1- 0-

/* Private function prototypes -----------------------------------------------*/
void SPI_Configuration(void);
void SPI_SetSpeed(u8 SpeedSet);

u8 SPI_ReadWriteByte(u8 TxData);                //SPI߶дһֽ
u8 SD_WaitReady(void);                          //ȴSD
u8 SD_SendCommand(u8 cmd, u32 arg, u8 crc);     //SDһ
u8 SD_SendCommand_NoDeassert(u8 cmd, u32 arg, u8 crc);
u8 SD_Init(void);                               //SDʼ
                                                //
u8 SD_ReceiveData(u8 *data, u16 len, u8 release);//SD
u8 SD_GetCID(u8 *cid_data);                     //SDCID
u8 SD_GetCSD(u8 *csd_data);                     //SDCSD
u32 SD_GetCapacity(void);                       //ȡSD

u8 SD_ReadSingleBlock(u32 sector, u8 *buffer);  //һsector
u8 SD_WriteSingleBlock(u32 sector, const u8 *buffer); //дһsector
u8 SD_ReadMultiBlock(u32 sector, u8 *buffer, u8 count); //sector
u8 SD_WriteMultiBlock(u32 sector, const u8 *data, u8 count);  //дsector

#endif
